/*
  Common JavaScript library.
  by Proger_XP | http://proger.i-forge.net
*/

function isset(aVar) {
  return typeof aVar != 'undefined' && aVar !== null;
}

function IsNonEmptyArray(aVar) {
  return typeof aVar == 'object' && aVar && IsNum(aVar.length) && aVar.length > 0;
}

function InstanceOf(obj, aVar) {
  obj = obj.toLowerCase();
  // no constructor.name in IE 6.
  var ctor = (aVar && aVar.constructor) ? aVar.constructor : '';
  return ctor.name ? (ctor.name.toLowerCase() == obj)
                   : (ctor.toString().toLowerCase().indexOf(obj) != -1);
}

function IsArray(aVar) {
  return typeof aVar == 'object' && InstanceOf('Array', aVar);
}

function IsNum(num) {
  switch (typeof num) {
  case 'number':  return !isNaN(num);
  // IE considers empty str and str with spaces as !isNaN. For some reason null is also !isNaN().
  case 'string':  return /^[\d\.]+$/.test(num);
  }
}

function IsFunc(func) {
  return typeof func == 'function';
}

function ArgumentsToArray(argsObject) {
  return Array.prototype.slice.call(argsObject);
}

function IsIE() {
  // window.ie_specific is set in <head> using CDATA comment so
  //   even a masked Opera won't be a problem.
  return typeof ieSpecific != 'undefined';
}

function IsIE6() {
  return typeof ieLt7 != 'undefined';
}

function IsTheTag(element, tag) {
  return typeof element == 'object' && element && element.nodeType == 1 &&
         ( !tag || element.tagName.toUpperCase() == tag.toUpperCase() );
}

// max - inclusive.
function Random(min, max) {
    min = parseInt(min);
    max = parseInt(max);
  return Math.floor(Math.random() * (max - min + 1)) + min;
}

function Microtime() {
  return (new Date()).getTime();
}

function ShallowCopyOf(obj) {
  if (IsArray(obj)) {
    return obj.concat();
  } else {
    var aCopy = {}
      for (prop in obj) { aCopy[prop] = obj[prop]; }
    return aCopy;
  }
}

// including last '/'.
function LocationPath() {
  return location.href.substr(0, location.href.lastIndexOf('/') + 1);
}

function IsValidEmail(str) {
  return str.match(/^[a-z0-9]([a-z0-9\-_\.]*[a-z0-9])?@[a-z0-9\-\.]+\.[a-z]{2,8}$/i) != null;
}

function ucfirst(str) { return str.replace(/./, str[0].toUpperCase()); }
function lcfirst(str) { return str.replace(/./, str[0].toLowerCase()); }

function StrRepeat(str, count) { return (new Array(parseInt(count) + 1)).join(str); }
function Trim(str) { return str.replace(/^[\0-\x20]+/g, '').replace(/[\0-\x20]+$/g, ''); }

function CancelPropagationOf(event) {
  event.cancelBubble = true;    // IE
  if (event.stopPropagation) {  // W3C
    event.stopPropagation();
  }

  event.returnValue = false;
  if (event.preventDefault) {
    event.preventDefault();
  }
}

function OriginalEventTargetOf(event) {
  return isset(event) && (event.srcElement || event.explicitOriginalTarget || event.originalTarget);
}

  var previousCapsLockStates = [];
function IsCapsLockOnIn(e) {
    if (!e) { return false; }

  var isCapsLockOn = false;

  var charCode = e.which || e.keyCode || e.charCode;
  var isShiftOn = e.shiftKey || e.modifiers & 4;

    var char_a = 'a'.charCodeAt(0); var char_z = 'z'.charCodeAt(0);
    var char_A = 'A'.charCodeAt(0); var char_Z = 'Z'.charCodeAt(0);
  if (isShiftOn) {
    isCapsLockOn = charCode >= char_a && charCode <= char_z;
  } else {
    isCapsLockOn = charCode >= char_A && charCode <= char_Z;
  }

  var isDefiniteState = (charCode >= char_a && charCode <= char_z) ||
                        (charCode >= char_A && charCode <= char_Z);

  var previousState = false;

  var target = OriginalEventTargetOf(e);
  if (IsTheTag(target) && target.id) {
    if (!isset( previousCapsLockStates[target.id] )) {
      previousCapsLockStates[target.id] = isCapsLockOn;
    }

    previousState = previousCapsLockStates[target.id];
  }

  if (!isDefiniteState) {
    isCapsLockOn |= previousState;
  }

  previousCapsLockStates[target.id] = isCapsLockOn;

  return isCapsLockOn;
}

// in addition to this function called in onmousemove you should also call
// CancelPropagationOf() in onmousedown: For example (Event.AddTo() can be used):
// document.body.onmousemove = function (e) { CancelDragOnMouseMove(e); ... }
// handleNode.onmousedown = function (e) { CancelPropagationOf(e); ... }
function CancelDragOnMouseMove(e) {
  CancelPropagationOf(e);

  if (window.opera) {
    var input = $('_Dragged_Opera_Input_');
    if (!IsTheTag(input)) {
      input = document.createElement('input');
      input.id = '_Dragged_Opera_Input_';
      $hide(input);

      document.body.appendChild(input);
    }

    input.focus();
  }
}

function MousePosFrom(e) {
  return {x: e.pageX || e.clientX + GetScrollX(), y: e.pageY || e.clientY + GetScrollY()};
}

function AddChainFuncTo(existingFunc, newFunc) {
  return function () {
    var args = ArgumentsToArray(arguments);
    newFunc.apply(this, args);

    if (IsFunc(existingFunc)) {
      existingFunc.apply(this, args);
    }
  }
}

function RequestScript(url, data, onEvalException) {
  var request = CreateXHRequest();
  if (request) {
    var method = data ? 'POST' : 'GET';
    request.open(method, url, true);
    request.onreadystatechange = function () {
      if (request.readyState == 4 && (request.status == 200 || request.status == 304 /*not modified*/)) {
        try {
          eval.call(window, request.responseText);
        } catch (e) {
          if (IsFunc(onEvalException)) {
            onEvalException(e);
          } else {
            throw e;
          }
        }
      }
    }

    if (isset(data)) {
      request.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
      request.setRequestHeader('Content-Length', data.length);
    }

    request.send(data);
  } else {
    var span = document.createElement('SPAN');
    $hide(span);

    if (isset(data)) {
      if (url.indexOf('?') == -1) {
        url += '?';
      }
      url += '&' + data;
    }

    span.innerHTML = 'IE workaround. ' +
                     '<sc'+'ript type="text/javascript" src="' + url + '">i-e</scri'+'pt>';

    document.body.appendChild(span);
  }

  return request;
}

function CreateXHRequest() {
  var request;

  try {
    request = new XMLHttpRequest();
  } catch (e) {
    var activex = new Array("MSXML2.XMLHTTP.6.0",
                            "MSXML2.XMLHTTP.5.0",
                            "MSXML2.XMLHTTP.4.0",
                            "MSXML2.XMLHTTP.3.0",
                            "MSXML2.XMLHTTP",
                            "Microsoft.XMLHTTP");

    for (var i = 0; i < activex.length && !request; i++) {
      try {
        request = new ActiveXObject(activex[i]);
      } catch (e) {}
    }
  }

  return request;
}

function LoadCSS(url) {
  var node = document.createElement('link');
      node.rel = 'stylesheet';
      node.type = 'text/css';
      node.href = url;
  document.getElementsByTagName('head')[0].appendChild(node);
}

function LoadJS(url) {
  var node = document.createElement('script');
      node.type = 'text/javascript';
      node.src = url;
  document.body.appendChild(node);
}

function HTMLToWrappedNodes(html, multipleAsArray) {
  if (html) {
    var wrapper = document.createElement('div');
    wrapper.innerHTML = html.replace(/^\s+/, '').replace(/\s+$/, '');

    return (wrapper.childNodes.length == 1 ? wrapper.firstChild
                                           : (multipleAsArray ? wrapper.childNodes
                                                              : wrapper));
  } else {
    return null;
  }
}

function HTMLToNode(html) {
  return HTMLToWrappedNodes(html, true);
}

function ModifyClassNameOf(element, className, append) {
    element = $(element);

  if (!IsTheTag(element)) { return; }

  if (!isset(append) || append) {
    if (!HasClass(element, className)) {
      element.className += ' ' + className;
    }
  } else {
    element.className = element.className.replace(ClassNameRegExpFor(className), ' ');
  }
}

function HasClass(element, className) {
  var regexp = ClassNameRegExpFor(className);
  return regexp.test($(element).className);
}

function ClassNameRegExpFor(className) {
  return new RegExp('(^|\\s)' + className + '(\\s|$)', 'gi');
}

function EscapeForString(str) {
  return str.replace(/([\r\n'\\])/g, '\\$1');
}

function EscapeForRegExp(str) {
  var quotedRegExp = new RegExp('(\\' + '.*+?^$|()[]{}\\'.split('').join('|\\') + ')', 'g');
  return str.replace(quotedRegExp, '\\$1');
}

// flags = string of chars '"', "'".
function EscapeForHTML(str, flags) {
  flags = isset(flags) ? flags : '';
  var entities = {'"': '&quot;', "'": '&apos;', '<': '&lt;', '>': '&gt;', '&': '&amp;'};

  var regexp = '[<>&';
  if (flags.indexOf('"')) { regexp += '"'; }
  if (flags.indexOf("'")) { regexp += "'"; }

  return str.replace(new RegExp(regexp + ']', 'g'), function (ch) { return entities[ch]; });
}

function EmulatePseudoclassesOn(element) {
  if (!element || !IsIE()) { return; }

    var oldMouseMove = element.onmousemove;
  element.onmousemove = function () { if (oldMouseMove) oldMouseMove(); ModifyClassNameOf(element, 'hovered', true); }
    var oldMouseOut = element.onmouseout;
  element.onmouseout = function () { if (oldMouseOut) oldMouseOut(); ModifyClassNameOf(element, 'hovered', false); }
    var oldFocus = element.onfocus;
  element.onfocus = function () { if (oldFocus) oldFocus(); ModifyClassNameOf(element, 'focused', true); }
    var oldBlur = element.onblur;
  element.onblur = function () { if (oldBlur) oldBlur(); ModifyClassNameOf(element, 'focused', false); }
}

function PlaceholderEditText(node, defaultValue, keepDefault) {
  node = $(node);
  if (IsTheTag(node)) {
    node.onfocus = function () {
      if (!keepDefault && node.value == defaultValue) { node.value = ''; }
      ModifyClassNameOf(node, 'filled');
    }

    node.onblur = function () {
      if (node.value.replace(/^ +| +$/g, '') == '' || node.value == defaultValue) {
        node.value = defaultValue;
        ModifyClassNameOf(node, 'filled', false);
      }
    }

    ModifyClassNameOf(node, 'filled', node.value != defaultValue);
  }
}

// timeout = int/false (null = 5).
// function (node, timeout)  or  function (node, DOMNode/string button)
function AutosubmitTextarea(node, timeout) {
  node = $(node);
  var form = FindParentOf(node, 'form', null);

  if (IsTheTag(node && form)) {
    var button = null;

      if (typeof timeout == 'string' || IsTheTag(timeout)) {
        button = $(timeout);
        timeout = 5;
      } else if (IsNum(timeout) || !isset(timeout)) {
        button = FindChildOf(form, 'button', null);

        if (!button) {
          var found;

            var buttons = FindChildrenOf(form, 'input', null);
            $each(buttons, function (button) {
              if (button.type == 'submit' || button.type == 'image') {
                return found = button;
              }
            });

          button = found;
        }
      }

    button && (button.disabled = false);

    Event.AddTo(node, 'keypress', function (e) {
      if (e.keyCode == 13 && e.ctrlKey && !e.altKey && ( !button || !button.disabled )) {
        if (IsFunc(form.onsubmit)) {
          var result = form.onsubmit();
          if (isset(result) && !result) { return; }
        }

        form.submit();
        CancelPropagationOf(e);

        if (button) {
          button.disabled = true;
          DisableSubmissionButton(button, (timeout || 5) * 1000);
        }
      }
    });
  }
}

function HighlightTextNodesOf(node, words) {
  node = $(node);
  if (IsNonEmptyArray(words)) {
    $each(words, function (word, i) { words[i] = EscapeForRegExp(word); });
    words = new RegExp('\\b(' + words.join('|') + '.*?\\b)', 'gi');
  }

  if (node && DebugAssert( typeof words == 'object' && InstanceOf('RegExp', words) )) {
    if (node.nodeType == 3) {
      var hilited = node.nodeValue.replace(words, '<span class="highlighted-term">$1</span>');
      if (hilited != node.nodeValue) {
        var newNode = document.createElement('span');
            newNode.innerHTML = hilited;
        node.parentNode.replaceChild(newNode, node);
      }
    } else if (IsTheTag(node)) {
      setTimeout(function () {
        $each(node.childNodes, function (child) {
          HighlightTextNodesOf(child, words);
        });
      }, 25);
    }
  }
}

function Bookmark(url, title) {
  if (IsTheTag(url) && url.href) {
    var anchor = url;
    url = anchor.href;
    title = anchor.title;
  }

  try {
    window.external.AddFavorite(url, title);
  } catch (e) {}
}

function SetHomePage(anchor, url) {
  if (IsTheTag(anchor) && anchor.style) {
    try {
      anchor.style.behavior = 'url(#default#homepage)';
      url = isset(url) ? url : document.location.href;
      anchor.setHomePage(url);
    } catch (e) {}
  }
}

function DebugRecord() {
  if (isset(window.console) && isset(window.console.firebug)) {
      var args = ArgumentsToArray(arguments);
    console.error('DebugRecord() invoked, args: ' + args.join(', '));
    console.trace();
  }
}

function DebugAssert(condition) {
  if (!condition) {
      var args = ArgumentsToArray(arguments);
      args.shift();
    DebugRecord.apply(this, args);
  }
  return condition;
}

// got from http://snippets.dzone.com/posts/show/849
function Shuffle(array) {
  for (i = array.length - 1; i >= 0; i--) {
    var otherIndex = parseInt(Math.random() * i);

    var temp = array[i];
      array[i] = array[otherIndex];
    array[otherIndex] = temp;
  }

  return array;
}

function $() {
  var a = [];
  var cx = window;

  for (var i = 0, l = arguments.length; i < l; i++) {
    var element = arguments[i];

    if (typeof arguments[i] == 'string') {
      element = document.getElementById(arguments[i]);
    }

    a.push(element);
  }

  return !IsNonEmptyArray(a) || a.length > 1 ? a : a[0];
}

function $hide(element, displayValue) {
  displayValue = displayValue ? displayValue : 'none';
  return $style(element, 'display', displayValue);
}

function $show(element, displayValue) {
  displayValue = displayValue ? displayValue : 'block';
  return $hide(element, displayValue);
}

function HeightOf(element, newHeight) {
    element = $(element);

  if (IsNum(newHeight)) {
    return parseInt( $style(element, 'height', Math.round(newHeight) + 'px') );
  } else {
    if (IsNum(element.offsetHeight)) {
      var extra = parseInt( $style(element, 'borderTopWidth') )
                  + parseInt( $style(element, 'borderBottomWidth') );
      return IsNum(extra) ? element.offsetHeight - extra : element.offsetHeight;
    } else {
      return parseInt( $style(element, 'height') );
    }
  }
}

function WidthOf(element, newWidth) {
    element = $(element);

  if (IsNum(newWidth)) {
    return parseInt( $style(element, 'width', Math.round(newWidth) + 'px') );
  } else {
    if (IsNum(element.offsetWidth)) {
      var extra = parseInt( $style(element, 'borderLeftWidth') )
                  + parseInt( $style(element, 'borderRightWidth') );
      return IsNum(extra) ? element.offsetWidth - extra : element.offsetWidth;
    } else {
      return parseInt( $style(element, 'width') );
    }
  }
}

function ExpandedHeightOf(elem) {
  var origHeight = $style(elem, 'height', 'auto');
  var origMaxHeight = $style(elem, 'maxHeight', 'none');
  var origOverflow = $style(elem, 'overflow', 'visible');
  var origDisplay = $style(elem, 'display', 'block');

    var height = HeightOf(elem);

  if (origDisplay != 'block') { $style(elem, 'display', origDisplay);; }
  if (origOverflow != 'visible') { $style(elem, 'overflow', origOverflow);; }
  if (! /^(none)?$/i.test(origMaxHeight)) { $style(elem, 'maxHeight', origMaxHeight);; }
  if (! /^(auto)?$/i.test(origHeight)) { $style(elem, 'height', origHeight);; }

  return height;
}

// Got from http://www.tigir.com/javascript.htm
function $style(element, prop, newValue) {
  element = $(element);

    if (!element) { return; }

  if (isset(newValue)) {
    var toSet = ArgumentsToArray(arguments);
        toSet.shift();
        if (toSet.length % 2 != 0) { toSet.pop(); }

    var oldValue = $style(element, prop);

      var propName;
      $each(toSet, function (elem, index) {
        if (index % 2 == 0) {
          propName = elem;
        } else {
          element.style[propName] = elem;
          // props won't be changed to wrong values.
          DebugAssert(element.style[propName] == elem, propName, 'got ' + element.style[propName],
                      'expected ' + elem);
        }
      });

    return oldValue;
  } else {
    if (document.defaultView && document.defaultView.getComputedStyle) {
      if (prop.match(/[A-Z]/)) prop = prop.replace(/([A-Z])/g, '-$1').toLowerCase();
      return document.defaultView.getComputedStyle(element, '').getPropertyValue(prop);
    } else if (element.currentStyle) {
      while ((i = prop.indexOf('-')) != -1) {
        prop = prop.substr(0, i) + prop.substr(i + 1, 1).toUpperCase() + prop.substr(i + 2);
      }
      return element.currentStyle[prop];
    } else {
      return '';
    }
  }
}

function ImmediateStyleOf(node, prop) {
  node = $(node);
  if (DebugAssert(node)) {
    prop = prop.replace(/([A-Z])/g, '-$1').toLowerCase();
    return node.style.getPropertyValue(prop);
  }
}

function $each(iterableObject, callback) {
  if (IsNonEmptyArray(iterableObject) || typeof iterableObject == 'string') {
    for (var i = 0; i < iterableObject.length; i++) {
      if (callback.call(this, iterableObject[i], i)) {
        break;
      }
    }
  } else if (typeof iterableObject == 'object') {
    for (var key in iterableObject) {
      if (callback.call(this, iterableObject[key], key)) {
        break;
      }
    }
  }
}

function GetAbsoluteXOf(element) {
  element = $(element);
  var x = 0;

  while (element) {
    x += element.offsetLeft;
    element = element.offsetParent;
  }

  return x;
}

function GetAbsoluteYOf(element) {
  element = $(element);
  var y = 0;

  while (element) {
    y += element.offsetTop;
    element = element.offsetParent;
  }

  return y;
}

// alpha = 0..100.
function $opacity(element, alpha) {
  alpha = Math.round(alpha);
  if (IsNum(alpha)) {
    $style(element, 'opacity', alpha / 100);
    $style(element, 'filter', 'alpha(opacity=' + alpha + ')');
  } else {
    alpha = $style(element, 'opacity') * 100;
  }

  return IsNum(alpha) ? parseFloat(alpha) : 100;
}

function GetScrollX() {
  return self.pageXOffset || (document.documentElement && document.documentElement.scrollLeft) ||
         (document.body && document.body.scrollLeft);
}

function GetScrollY() {
  return self.pageYOffset || (document.documentElement && document.documentElement.scrollTop) ||
         (document.body && document.body.scrollTop);
}

// got from http://www.howtocreate.co.uk/tutorials/javascript/browserwindow
function WindowWidth() {
  if (IsNum(window.innerWidth)) {  // Non-IE
    return window.innerWidth;
  } else if (document.documentElement && IsNum(document.documentElement.clientWidth)) {
    // IE 6+ in 'standards compliance mode'
    return document.documentElement.clientWidth;
  } else if (document.body) {       // IE 4 compatible
    return document.body.clientWidth;
  }
}

// got from http://www.howtocreate.co.uk/tutorials/javascript/browserwindow
function WindowHeight() {
  if (IsNum(window.innerHeight)) {  // Non-IE
    return window.innerHeight;
  } else if (document.documentElement && IsNum(document.documentElement.clientHeight)) {
    // IE 6+ in 'standards compliance mode'
    return document.documentElement.clientHeight;
  } else if (document.body) {        // IE 4 compatible
    return document.body.clientHeight;
  }
}

function DocumentWidth() {
  return Math.max(
    Math.max(document.body.scrollWidth, document.documentElement.scrollWidth),
    Math.max(document.body.offsetWidth, document.documentElement.offsetWidth),
    Math.max(document.body.clientWidth, document.documentElement.clientWidth)
  );
}

// got from http://james.padolsey.com/javascript/get-document-height-cross-browser/
function DocumentHeight() {
  return Math.max(
    Math.max(document.body.scrollHeight, document.documentElement.scrollHeight),
    Math.max(document.body.offsetHeight, document.documentElement.offsetHeight),
    Math.max(document.body.clientHeight, document.documentElement.clientHeight)
  );
}

// default timeout = 5000.
function DisableSubmissionButton(button, timeout) {
  button = $(button);

    if (!DebugAssert(button)) { return; }

    function Toggle(enable) {
      button.disabled = !enable;
      ModifyClassNameOf(button, 'under-submission', !enable);
    }

  // if button is disabled right away Opera will cancel current submission.
  setTimeout(function () { Toggle(false); }, 100);

  timeout = IsNum(timeout) ? timeout : 5000;
  setTimeout(function () { Toggle(true); }, timeout);
}

function $get(element) {
  element = $(element);

    if (!DebugAssert(element)) { return; }

  switch (element.tagName) {
  case 'INPUT':
  case 'TEXTAREA':
  case 'SELECT':
    return element.value;
  default:
    return element.innerHTML;
  }
}

function $set(element, value) {
  element = $(element);

    if (!DebugAssert(element)) { return; }

  switch (element.tagName) {
  case 'INPUT':
  case 'TEXTAREA':
  case 'SELECT':
    prevValue = element.value;
    element.value = value;
    break;
  default:
    prevValue = element.innerHTML;
    element.innerHTML = value;
  }

  return prevValue;
}

function RemoveChildrenOf(parent) {
  if (IsTheTag(parent)) {
    while (parent.children.length > 0) {
      parent.removeChild( parent.children[0] )
    }
  }
}

function FindParentOf(firstElement, tagName, className) {
    firstElement = $(firstElement);
    var regexp = ClassNameRegExpFor(className);

  while (firstElement && (!IsTheTag(firstElement, tagName) || ( className && !firstElement.className.match(regexp) ))) {
    firstElement = firstElement.parentNode;
  }

  return firstElement;
}

// possible calls:
// FindChildOf(parent, tagName, className)
// FindChildOf(parent, className) - don't check tag name
// FindChildOf(parent, tagName, null) - (3 args - pass null explicitly) - don't check class name.
function FindChildrenOf(parent, tagName, className) {
  if (arguments.length == 2) {
    className = tagName;
    tagName = null;
  }

  var found = [];

    parent = $(parent);
    parent ? parent = parent.firstChild : null;
    var regexp = ClassNameRegExpFor(className);

  while (parent) {
    if (IsTheTag(parent, tagName) && (!className || parent.className.match(regexp))) {
      found.push(parent);
    }
    parent = parent.nextSibling;
  }

  return found;
}

function FindChildOf(parent, tagName, className) {
  var args = ArgumentsToArray(arguments);
  var all = FindChildrenOf.apply(this, args);
  return IsNonEmptyArray(all) ? all[0] : null;
}

function FindChildByPath(parent) {
  for (var i = 1; parent && i < arguments.length; i++) {
    var args = IsNonEmptyArray(arguments[i]) ? arguments[i] : [arguments[i]];
    args.unshift(parent);
    parent = FindChildOf.apply(this, args);
  }
  return parent;
}

// got from xpoint.ru
function AddOnLoad(f) {
 var root = window.addEventListener || window.attachEvent ? window : document.addEventListener ? document : null
 if (root) {
    if (root.addEventListener) root.addEventListener("load", f, false)
    else if (root.attachEvent) root.attachEvent("onload", f)
 } else {
    window.onload = AddChainFuncTo(window.onload, f);
 }
}

// got from http://v3.thewatchmakerproject.com/zebra.html,
// referred to at http://v3.thewatchmakerproject.com/journal/168/
window.Event = {
  AddTo: function (obj, type, fn) {
    if (obj.attachEvent) {
      obj['e' + type + fn] = fn;
      obj[type + fn] = function() { obj['e' + type + fn](window.event); }
      obj.attachEvent('on' + type, obj[type + fn]);
    } else {
      obj.addEventListener(type, fn, false);
    }
  },

  RemoveFrom: function (obj, type, fn) {
    if (obj.detachEvent) {
      obj.detachEvent('on' + type, obj[type + fn]);
      obj[type + fn] = null;
    } else {
      obj.removeEventListener(type, fn, false);
    }
  }
}

function RestartTimer(timer, callback, delay) {
  clearTimeout(timer);
  return setTimeout(callback, delay);
}

function SetPagebarHotkeys(prevLinkID, nextLinkID) {
    if (!prevLinkID) { prevLinkID = 'pagebarPrev'; }
    if (!nextLinkID) { nextLinkID = 'pagebarNext'; }

  document.onkeydown = AddChainFuncTo(document.onkeydown, function (e) {
    if (!e) { e = window.event; }

    var link = null;

      if (e.ctrlKey) {
        switch (e.keyCode) {
        case 37: link = prevLinkID; break;
        case 39: link = nextLinkID; break;
        }
      }

    if (link = $(link)) { location.href = link.href; }
  });
}

function GetCookie(name) {
  var start = document.cookie.indexOf(name + "=");
  var len = start + name.length + 1;
  if (!start && name != document.cookie.substring(0, name.length)) {
    return null;
  }
  if (start == -1) {
    return null;
  }

  var end = document.cookie.indexOf(';', len);
  if (end == -1) {
    end = document.cookie.length;
  }
  return unescape( document.cookie.substring(len, end) );
}

// expires - hours.
function SetCookie(name, value, expires, path, domain, secure) {
  // set time, it's in milliseconds
  var today = new Date();
  today.setTime( today.getTime() );

  if (expires) {
    expires = expires * 1000 * 3600;
  }
  var expiresDate = new Date( today.getTime() + expires );

  if (typeof value == 'boolean') { value = value ? 1 : 0; }

  document.cookie = name + "=" + escape(value) +
                    ( (expires) ? ";expires=" + expiresDate.toGMTString() : "" ) +
                    ( (path)    ? ";path=" + path : "" ) +
                    ( (domain)  ? ";domain=" + domain : "" ) +
                    ( (secure)  ? ";secure" : "" );
}

function DeleteCookie(name, path, domain, secure) {
  SetCookie(name, '', -24 * 30, path, domain, secure);
}
